﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace graphicbox2d.オブジェクトマネージャー
{
    internal static class DrawManager
    {
        /// <summary>
        /// ペンマネージャー
        /// </summary>
        internal static readonly PenManager Pen = new PenManager();

        /// <summary>
        /// 矢印ペンマネージャー
        /// </summary>
        internal static readonly ArrowPenManager ArrowPen = new ArrowPenManager();

        /// <summary>
        /// ブラシマネージャー
        /// </summary>
        internal static readonly BrushManager Brush = new BrushManager();

        /// <summary>
        /// フォントマネージャー
        /// </summary>
        internal static readonly FontManager Font = new FontManager();

        /// <summary>
        /// ペンを取得する
        /// </summary>
        /// <param name="color">色</param>
        /// <param name="width">太さ</param>
        /// <param name="dashStyle">線種</param>
        /// <param name="dashPattern">カスタムパターン（DashStyle.Custom時のみ有効）</param>
        /// <returns>ペン</returns>
        internal static Pen GetPen(Color color, float width = 1.0f, DashStyle dashStyle = DashStyle.Solid, float[] dashPattern = null)
        {
            return Pen.GetPen(color, width, dashStyle, dashPattern);
        }

        /// <summary>
        /// ペンを取得する
        /// </summary>
        /// <param name="color">色</param>
        /// <param name="width">太さ</param>
        /// <param name="dashStyle">線種</param>
        /// <param name="startCap">始点キャップ</param>
        /// <param name="endCap">終点キャップ</param>
        /// <param name="dashPattern">カスタムパターン（DashStyle.Custom時のみ有効）</param>
        /// <returns>ペン</returns>
        internal static Pen GetArrowPen(Color color, float width = 1.0f,
                  DashStyle dashStyle = DashStyle.Solid,
                  Arrow2DLineCapType startCap = Arrow2DLineCapType.None,
                  Arrow2DLineCapType endCap = Arrow2DLineCapType.None,
                  float[] dashPattern = null)
        {
            return ArrowPen.GetPen(color, width, dashStyle, startCap, endCap, dashPattern);
        }

        /// <summary>
        /// ソリッドブラシを取得する
        /// </summary>
        /// <param name="color"></param>
        /// <returns>ソリッドブラシ</returns>
        /// <exception cref="ObjectDisposedException"></exception>
        internal static SolidBrush GetSolidBrush(Color color)
        {
            return Brush.GetSolidBrush(color);
        }

        /// <summary>
        /// ハッチブラシを取得する
        /// </summary>
        /// <param name="style">ハッチスタイル</param>
        /// <param name="foreColor">カラー</param>
        /// <param name="backColor">背景色</param>
        /// <returns>ハッチブラシ</returns>
        internal static HatchBrush GetHatchBrush(HatchStyle style, Color foreColor, Color backColor)
        {
            return Brush.GetHatchBrush(style, foreColor, backColor);
        }

        /// <summary>
        /// フォントを取得する
        /// </summary>
        /// <param name="FontName">フォント名</param>
        /// <param name="FontSize">サイズ</param>
        /// <param name="style">スタイル（省略可）</param>
        /// <returns>フォント</returns>
        internal static Font GetFont(string FontName, float FontSize, FontStyle style = FontStyle.Regular)
        {
            return Font.GetFont(FontName, FontSize, style);
        }
    }
}
